<?php
// includes/auth.php - autenticación simple
session_start();
require_once __DIR__ . '/db.php';

function findUserByEmail($email) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
    $stmt->execute([$email]);
    return $stmt->fetch();
}

function createUser($name, $email, $password) {
    global $pdo, $config;
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $config = require __DIR__ . '/../config.php';
    $start = date('Y-m-d H:i:s');
    $end = date('Y-m-d H:i:s', strtotime("+{$config['app']['trial_days']} days"));
    $stmt = $pdo->prepare('INSERT INTO users (name,email,password,trial_starts,trial_ends,status) VALUES (?,?,?,?,?,?)');
    $stmt->execute([$name,$email,$hash,$start,$end,'pending']);
    return $pdo->lastInsertId();
}

function login($email, $password) {
    $user = findUserByEmail($email);
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        return true;
    }
    return false;
}

function currentUser() {
    global $pdo;
    if (isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare('SELECT * FROM users WHERE id = ?');
        $stmt->execute([$_SESSION['user_id']]);
        return $stmt->fetch();
    }
    return null;
}
