<?php
// scripts/provision.php - busca usuarios 'pending' y crea servicio en SonicPanel
require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/sonicpanel.php';
$config = require __DIR__ . '/../config.php';
$sp = new SonicPanel($config['sonicpanel']);

$stmt = $pdo->prepare("SELECT * FROM users WHERE status = 'pending'");
$stmt->execute();
$users = $stmt->fetchAll();

foreach ($users as $u) {
    try {
        $servicePass = substr(bin2hex(random_bytes(6)),0,10);
        $package = 'starter';
        $resp = $sp->createService($u['email'], $package, $servicePass);
        if (isset($resp['service_id'])) {
            $stmt2 = $pdo->prepare('UPDATE users SET sonicpanel_service_id = ?, status = ? WHERE id = ?');
            $stmt2->execute([$resp['service_id'],'active',$u['id']]);
            $stmt3 = $pdo->prepare('INSERT INTO sonic_events (user_id, action, payload) VALUES (?,?,?)');
            $stmt3->execute([$u['id'],'service_created',json_encode($resp)]);
        } else {
            $stmt3 = $pdo->prepare('INSERT INTO sonic_events (user_id, action, payload) VALUES (?,?,?)');
            $stmt3->execute([$u['id'],'service_failed',json_encode($resp)]);
        }
    } catch (Exception $e) {
        $stmt3 = $pdo->prepare('INSERT INTO sonic_events (user_id, action, payload) VALUES (?,?,?)');
        $stmt3->execute([$u['id'],'exception',$e->getMessage()]);
    }
}
